/***************************************************************/
//
//
//		DirectX	[title_rot_player.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 05/30
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

Update : 2016/06/06
			_obt@[̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "title_rot_player.h"
#include "formula.h"
#include "bg_obj.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define PLAYER_TEXTURENAME "data/TEXTURE/runningman102.png"

#define PLAYER_POS_X (300)							//|S̕\ʒuX
#define PLAYER_POS_Y (300)							//|S̕\ʒuY
#define PLAYER_WIDTH (440)							//|S̕
#define PLAYER_HEIGHT (400)							//|S̍

#define PLAYER_RADIUS_X ( 70/2 )					//wiIuWFNg̔aX
#define PLAYER_RADIUS_Y ( 50/2 )					//wiIuWFNg̔aY

#define PLAYER_TEXTURE_U_SIZE (0.2f)
#define PLAYER_TEXTURE_V_SIZE (0.5f)


/*---------------------------------------------------------------
	\
---------------------------------------------------------------*/

// player\
typedef struct{

	float playerTexU;
	float playerTexV;

	float playerTexMoveX;
	float playerTexMoveY;

	float playerTexX;
	float playerTexY;
	float playerTexX2;
	float playerTexY2;

	float playerTexX3;
	float playerTexY3;
	float playerTexX4;
	float playerTexY4;

	VECTOR_2D vec;

	unsigned int playerFrame;
	//unsigned float playerFrame;

}PLAYER;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexTitlePlayer(LPDIRECT3DDEVICE9 pDevice);
													//_̍쐬
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureTitlePlayer = nullptr;	//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferTitlePlayer = nullptr;
													//_obt@C^[tF[Xւ̃|C^
PLAYER g_titlePlayer;								//郉jO}̍\

int titleArc = 0;									//ƃjO}̉]px

// TP̏
void InitTitlePlayer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;		//foCX󂯎p֐


	// foCX̎󂯎
	pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexTitlePlayer(pDevice);

	// eNX`̓ǂݍ
	if(FAILED(D3DXCreateTextureFromFile(pDevice,PLAYER_TEXTURENAME,&g_pTextureTitlePlayer)))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}


}
// TP̏I
void UninitTitlePlayer( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureTitlePlayer)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferTitlePlayer)

}
// TP̍XV
void UpdateTitlePlayer( void ){

	VERTEX_2D *pVtx;									//zAhX
	unsigned int radius;								//a

	// UVlvZ
	g_titlePlayer.playerTexU = (float)( ( g_titlePlayer.playerFrame ) % 5 ) * PLAYER_TEXTURE_U_SIZE;
	g_titlePlayer.playerTexV = (float)( (g_titlePlayer.playerFrame/5) %2 ) * PLAYER_TEXTURE_V_SIZE;
	//playerTexU = ( ( playerFrame ) % 5 ) * PLAYER_TEXTURE_U_SIZE;
	//playerTexV = ( (playerFrame/5) %2 ) * PLAYER_TEXTURE_V_SIZE;
	
	// a
	titleArc-=15;

	radius = OBJ_BG_RADIUS + PLAYER_RADIUS_Y;			
	
	g_titlePlayer.playerTexMoveX = radius * cos( RADIAN(titleArc) );
	g_titlePlayer.playerTexMoveY = radius * sin( RADIAN(titleArc) );
	
	// |S̉]
	g_titlePlayer.playerTexX = (-PLAYER_RADIUS_X) * cos( RADIAN(titleArc) ) - (-PLAYER_RADIUS_Y) * sin( RADIAN(titleArc) );
	g_titlePlayer.playerTexY = (-PLAYER_RADIUS_X) * sin( RADIAN(titleArc) ) + (-PLAYER_RADIUS_Y) * cos( RADIAN(titleArc) );
	g_titlePlayer.playerTexX2 = PLAYER_RADIUS_X * cos( RADIAN(titleArc) ) - (-PLAYER_RADIUS_Y) * sin( RADIAN(titleArc) );
	g_titlePlayer.playerTexY2 = PLAYER_RADIUS_X * sin( RADIAN(titleArc) ) + (-PLAYER_RADIUS_Y) * cos( RADIAN(titleArc) );
	g_titlePlayer.playerTexX3 = (-PLAYER_RADIUS_X) * cos( RADIAN(titleArc) ) - (PLAYER_RADIUS_Y) * sin( RADIAN(titleArc) );
	g_titlePlayer.playerTexY3 = (-PLAYER_RADIUS_X) * sin( RADIAN(titleArc) ) + (PLAYER_RADIUS_Y) * cos( RADIAN(titleArc) );
	g_titlePlayer.playerTexX4 = (PLAYER_RADIUS_X) * cos( RADIAN(titleArc) ) - (PLAYER_RADIUS_Y) * sin( RADIAN(titleArc) );
	g_titlePlayer.playerTexY4 = (PLAYER_RADIUS_X) * sin( RADIAN(titleArc) ) + (PLAYER_RADIUS_Y) * cos( RADIAN(titleArc) );
	

	// obt@bNzAhX擾
	g_pVtxBufferTitlePlayer -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN


	// UVAj[V
	pVtx[0].tex=D3DXVECTOR2( g_titlePlayer.playerTexU, g_titlePlayer.playerTexV );
	pVtx[1].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_titlePlayer.playerTexU, g_titlePlayer.playerTexV );
	pVtx[2].tex=D3DXVECTOR2( g_titlePlayer.playerTexU, PLAYER_TEXTURE_V_SIZE+g_titlePlayer.playerTexV );
	pVtx[3].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_titlePlayer.playerTexU, PLAYER_TEXTURE_V_SIZE+g_titlePlayer.playerTexV );

	// _XV
	pVtx[0].pos=D3DXVECTOR3( OBJ_BG_CENTER_X+g_titlePlayer.playerTexX2+g_titlePlayer.playerTexMoveX, OBJ_BG_CENTER_Y+g_titlePlayer.playerTexY2+g_titlePlayer.playerTexMoveY, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( OBJ_BG_CENTER_X+g_titlePlayer.playerTexX4+g_titlePlayer.playerTexMoveX, OBJ_BG_CENTER_Y+g_titlePlayer.playerTexY4+g_titlePlayer.playerTexMoveY, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( OBJ_BG_CENTER_X+g_titlePlayer.playerTexX+g_titlePlayer.playerTexMoveX, OBJ_BG_CENTER_Y+g_titlePlayer.playerTexY+g_titlePlayer.playerTexMoveY, 0.0f);
	pVtx[3].pos=D3DXVECTOR3( OBJ_BG_CENTER_X+g_titlePlayer.playerTexX3+g_titlePlayer.playerTexMoveX, OBJ_BG_CENTER_Y+g_titlePlayer.playerTexY3+g_titlePlayer.playerTexMoveY, 0.0f);
	

	//ColorPlayer ( pVtx );

	// obt@̃AbN
	g_pVtxBufferTitlePlayer->Unlock();

	g_titlePlayer.playerFrame++;

}
// TP̕`
void DrawTitlePlayer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;					//foCX󂯎p֐


	// foCX̎󂯎菈
	pDevice=GetDevice( );

	// Xg[
	pDevice->SetStreamSource(0,							//MS
	g_pVtxBufferTitlePlayer,							//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)
		
	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	pDevice->SetTexture(0,g_pTextureTitlePlayer);		//_UVf[^Zbg
	
	// |S̕`
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_PLAYER);


}
// TP̍쐬
HRESULT MakeVertexTitlePlayer( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferTitlePlayer,					//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferTitlePlayer -> Lock(0,0,(void**)&pVtx,0);	//GPUVRAMւ̑bN

	// _W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_POS_Y, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_POS_Y, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_HEIGHT,0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_HEIGHT,0.0f);

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );

	// obt@̃AbN
	g_pVtxBufferTitlePlayer->Unlock();

	return S_OK;

}

